/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_GPIO_API_
#define SPICE3_GPIO_API_

#include "rlTypes.h"

RL_C_API rlResult rlGpioInitConfig(rlGpioConfig* config);
RL_C_API rlResult rlGpioToStringConfig(const rlGpioConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlGpioLoadConfig(rlHandle handle);
RL_C_API rlResult rlGpioStoreConfig(rlHandle handle);
RL_C_API rlResult rlGpioGetConfig(rlHandle handle, rlGpioConfig* config);
RL_C_API rlResult rlGpioSetConfig(rlHandle handle, const rlGpioConfig* config);

RL_C_API rlResult rlGpioGetPinCount(rlHandle handle, rlIOPort port, int32_t* pinCount);
RL_C_API rlResult rlGpioGetGroupCount(rlHandle handle, rlIOPort port, int32_t* groupCount);
RL_C_API rlResult rlGpioGetSupportedIOLevels(rlHandle handle, rlIOPort port, rlIOVoltage* ioLevels, uint32_t ioLevelsSize, uint32_t* ioLevelsCount);
RL_C_API rlResult rlGpioGetSupportedDirections(rlHandle handle, rlIOPort port, rlIODirection* directions, uint32_t directionsSize, uint32_t* directionsCount);
RL_C_API rlResult rlGpioGetAvailableIOPinMappingList(rlHandle handle, rlIOPinMapping* pinMappings, uint32_t pinMappingsSize, uint32_t* pinMappingsCount);

RL_C_API rlResult rlGpioGetIOLevel(rlHandle handle, rlIOPort port, rlIOVoltage* ioLevel);
RL_C_API rlResult rlGpioSetIOLevel(rlHandle handle, rlIOPort port, rlIOVoltage ioLevel);

RL_C_API rlResult rlGpioGetPolarities(rlHandle handle, rlIOPort port, rlPolarity* polarities, uint32_t polaritiesSize, uint32_t* polaritiesCount);
RL_C_API rlResult rlGpioSetPolarities(rlHandle handle, rlIOPort port, const rlPolarity* polarities, uint32_t polaritiesLength);

RL_C_API rlResult rlGpioGetFunctions(rlHandle handle, rlIOPort port, int32_t* functions, uint32_t functionsSize, uint32_t* functionsCount);
RL_C_API rlResult rlGpioSetFunctions(rlHandle handle, rlIOPort port, const int32_t* functions, uint32_t functionsLength);

RL_C_API rlResult rlGpioGetDirections(rlHandle handle, rlIOPort port, rlIODirection* directions, uint32_t directionsSize, uint32_t* directionsCount);
RL_C_API rlResult rlGpioSetDirections(rlHandle handle, rlIOPort port, const rlIODirection* directions, uint32_t directionsLength);

RL_C_API rlResult rlGpioGetWriteDelay(rlHandle handle, rlIOPort port, double* delay);
RL_C_API rlResult rlGpioSetWriteDelay(rlHandle handle, rlIOPort port, double delay);
RL_C_API rlResult rlGpioGetWriteWidth(rlHandle handle, rlIOPort port, double* width);
RL_C_API rlResult rlGpioSetWriteWidth(rlHandle handle, rlIOPort port, double width);

RL_C_API rlResult rlGpioRead(rlHandle handle, rlIOPort port, uint32_t* value);
RL_C_API rlResult rlGpioGetOutput(rlHandle handle, rlIOPort port, uint32_t* value);
RL_C_API rlResult rlGpioWrite(rlHandle handle, rlIOPort port, rlPinAction action, uint32_t value);

#endif // _SPICE3_GPIO_API_